﻿using AZVIC.Ei8htPOS.POSRetail.Constants;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for Admin.xaml
    /// </summary>
    public partial class Admin : Page
    {
        public Admin()
        {
            InitializeComponent();
            if (AppSession.CurrentAdminUser != null && (AppSession.CurrentAdminUser.UserName.ToLower().Equals("admin") || AppSession.CurrentAdminUser.UserName.ToLower().Equals("azvicadmin")))
            {
                btnAppSettings.Visibility = Visibility.Visible;
            }
            else
            {
                btnAppSettings.Visibility = Visibility.Collapsed;
            }
        }
        public void OpenPendingTransaction()
        {
            (this.FindName("frmAdmin") as Frame).Navigate(new PendingTransactions());
        }

        private void btnPendingTransaction_Click(object sender, RoutedEventArgs e)
        {
            OpenPendingTransaction();
        }

        

        private void btnCompletedTransaction_Click(object sender, RoutedEventArgs e)
        {
            (this.FindName("frmAdmin") as Frame).Navigate(new SuccessfulTransactions());
        }

        private void btnPrinters_Click(object sender, RoutedEventArgs e)
        {
            Controls.SelectPrinter printer = new Controls.SelectPrinter();
            printer.Owner = Application.Current.MainWindow;
            printer.ShowInTaskbar = false;
            printer.ShowDialog();
        }
        private void btnSync_Click(object sender, RoutedEventArgs e)
        {
            (this.FindName("frmAdmin") as Frame).Navigate(new SyncToLiveDatabase());
        }

        private void btnHappyHoursDiscount_Click(object sender, RoutedEventArgs e)
        {
            Controls.SelectPrinter printer = new Controls.SelectPrinter();
            printer.Owner = Application.Current.MainWindow;
            printer.ShowInTaskbar = false;
            printer.ShowDialog();

        }

        private void btnHappyHour_Click(object sender, RoutedEventArgs e)
        {
            Controls.HappyHourSelection _HappyHour = new Controls.HappyHourSelection();
            _HappyHour.Owner = Application.Current.MainWindow;
            _HappyHour.ShowInTaskbar = false;
            _HappyHour.ShowDialog();
        }

        private void btnTax_Click(object sender, RoutedEventArgs e)
        {
            (this.FindName("frmAdmin") as Frame).Navigate(new Controls.TaxSelection());
        }

        private void btnTable_Click(object sender, RoutedEventArgs e)
        {

        }

        private void btnAppSettings_Click_1(object sender, RoutedEventArgs e)
        {
            (this.FindName("frmAdmin") as Frame).Navigate(new AppSettings());
        }
    }
}
